import defaultTheme from 'tailwindcss/defaultTheme';

/** @type {import('tailwindcss').Config} */
export default {
    content: [
        './vendor/laravel/framework/src/Illuminate/Pagination/resources/views/*.blade.php',
        './storage/framework/views/*.php',
        './resources/**/*.blade.php',
        './resources/**/*.js',
        './resources/**/*.vue',
    ],
    theme: {
        extend: {
            fontFamily: {
                sans: ['Figtree', ...defaultTheme.fontFamily.sans],
            },
            colors: {
                primary: {
                    DEFAULT: '#5D4037', // Dark brown - للعناصر الرئيسية
                    light: '#8D6E63', // Medium brown - للعناصر الفاتحة
                    lighter: '#BCAAA4', // Light brown - للخلفيات الفاتحة
                },
                secondary: {
                    DEFAULT: '#FF6B35', // Orange-red - للعناصر المميزة
                    light: '#FF8A65', // Light orange-red
                },
                accent: {
                    DEFAULT: '#E8D5C4', // Sandy beige - للخلفيات
                    light: '#F5E6D3', // Light beige
                },
                success: {
                    DEFAULT: '#76c791',
                },
            },
        },
    },
    plugins: [],
};
