<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\HomeController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\CartController;
use App\Http\Controllers\OrderController;

Route::middleware(['web', 'setlocale'])->group(function () {
    Route::get('/', [HomeController::class, 'index'])->name('home');
    
    Route::get('/products', [ProductController::class, 'index'])->name('products.index');
    Route::get('/products/{id}', [ProductController::class, 'show'])->name('products.show');
    
    // Cart routes - available for guests but prevent admins
    Route::middleware('not.admin')->group(function () {
        Route::get('/cart', [CartController::class, 'index'])->name('cart.index');
        Route::post('/cart', [CartController::class, 'store'])->name('cart.store');
        Route::put('/cart/{id}', [CartController::class, 'update'])->name('cart.update');
        Route::delete('/cart/{id}', [CartController::class, 'destroy'])->name('cart.destroy');
    });
    
    // Order routes - require authentication and prevent admins
    Route::middleware(['auth', 'not.admin'])->group(function () {
        Route::get('/orders', [OrderController::class, 'index'])->name('orders.index');
        Route::get('/orders/create', [OrderController::class, 'create'])->name('orders.create');
        Route::post('/orders', [OrderController::class, 'store'])->name('orders.store');
        Route::get('/orders/{id}', [OrderController::class, 'show'])->name('orders.show');
    });
    
    Route::get('/track-order', [OrderController::class, 'track'])->name('orders.track');
    
    // Serve storage images through Laravel (fallback for 403 errors)
    Route::get('/storage/{path}', function ($path) {
        $filePath = storage_path('app/public/' . $path);
        
        if (!file_exists($filePath) || !is_file($filePath)) {
            abort(404);
        }
        
        $mimeType = mime_content_type($filePath);
        $fileSize = filesize($filePath);
        
        return response()->file($filePath, [
            'Content-Type' => $mimeType,
            'Content-Length' => $fileSize,
            'Cache-Control' => 'public, max-age=31536000',
        ]);
    })->where('path', '.*')->name('storage.serve');
});

// Admin routes - require admin authentication
Route::middleware(['auth', 'admin'])->prefix('admin')->name('admin.')->group(function () {
    // Dashboard/Settings
    Route::get('sliders', [\App\Http\Controllers\Admin\SettingsController::class, 'index'])->name('sliders.index');
    
    // Resources
    Route::resource('categories', \App\Http\Controllers\Admin\CategoryController::class);
    Route::resource('sizes', \App\Http\Controllers\Admin\SizeController::class);
    Route::resource('products', \App\Http\Controllers\Admin\ProductController::class);
    Route::resource('orders', \App\Http\Controllers\Admin\OrderController::class)->only(['index', 'show']);
    Route::post('orders/{id}/status', [\App\Http\Controllers\Admin\OrderController::class, 'updateStatus'])->name('orders.updateStatus');
    Route::get('sliders/list', [\App\Http\Controllers\Admin\SliderController::class, 'index'])->name('sliders.list');
    Route::resource('sliders', \App\Http\Controllers\Admin\SliderController::class)->except(['index']);
});

require __DIR__.'/auth.php';
