@extends('layouts.app')

@section('title', $product->name)

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="py-8">
        <div class="bg-white rounded-lg shadow-lg overflow-hidden">
            <div class="md:flex">
                <div class="md:w-1/2">
                    @if($product->image)
                    <img src="{{ $product->image_url }}" alt="{{ $product->name }}" class="w-full h-auto object-contain">
                    @else
                    <div class="w-full h-96 bg-gray-200 flex items-center justify-center">
                        <span class="text-gray-400">{{ __('messages.no_image') ?? 'No Image' }}</span>
                    </div>
                    @endif
                </div>
                <div class="md:w-1/2 p-8">
                    <h1 class="text-3xl font-bold mb-4">{{ $product->name }}</h1>
                    <p class="text-gray-600 mb-4">{{ $product->description }}</p>
                    
                    @if(request()->boolean('from_cart') && isset($selectedSizeFromCart) && $selectedSizeFromCart)
                    <div class="mb-4 p-3 bg-blue-50 border border-blue-200 rounded-lg text-sm text-blue-800">
                        <div class="flex items-center gap-2">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 16h-1v-4h-1m1-4h.01M12 18a9 9 0 110-18 9 9 0 010 18z"></path>
                            </svg>
                            <span>أنت تعدّل منتجاً من السلة. القياس المختار حالياً: <strong class="font-semibold">{{ $selectedSizeFromCart->name }}</strong></span>
                        </div>
                    </div>
                    @endif

                    <div class="mb-4">
                        <span class="text-3xl font-bold text-primary">{{ number_format($product->price, 2) }} ر.ع</span>
                        @if($product->points_earned > 0)
                        <span class="ml-2 text-success">+{{ $product->points_earned }} {{ __('messages.points') }}</span>
                        @endif
                    </div>

                    <div class="mb-4">
                        @php
                            $actualStock = $product->sizes->count() > 0 
                                ? $product->sizes->sum(function($size) { return $size->pivot->stock ?? 0; })
                                : $product->stock;
                        @endphp
                        <span class="text-sm {{ $actualStock > 0 ? 'text-success' : 'text-primary' }}">
                            {{ $actualStock > 0 ? __('messages.in_stock') : __('messages.out_of_stock') }}
                        </span>
                        <span class="text-sm text-gray-600"> ({{ __('messages.stock') }}: {{ $actualStock }})</span>
                    </div>

                    @php
                        $comingFromCartWithCustom = request()->boolean('from_cart') && isset($customMeasurementsFromCart) && $customMeasurementsFromCart;
                        $isEditingFromCart = request()->boolean('from_cart') && (request()->has('cart_item') || $comingFromCartWithCustom || (isset($selectedSizeFromCart) && $selectedSizeFromCart));
                    @endphp

                    @if($product->is_custom && !$isEditingFromCart)
                    <div class="mb-4 p-4 bg-purple-50 border border-purple-200 rounded-lg">
                        <div class="flex items-center gap-2 mb-2">
                            <svg class="w-5 h-5 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                            </svg>
                            <span class="font-semibold text-purple-800">منتج تفصيل</span>
                        </div>
                        <p class="text-sm text-purple-700 mb-3">هذا المنتج قابل للتفصيل حسب القياسات المطلوبة</p>
                        @if($product->category_id == 8)
                        <p class="text-sm text-green-700 font-semibold mb-3 bg-green-50 border border-green-200 rounded px-3 py-2">
                            ⚠️ رسوم التفصيل: +5.00 ر.ع (تضاف على السعر الأساسي)
                        </p>
                        @endif
                        <div class="flex gap-2">
                            <button type="button" id="custom-order-btn" class="bg-gray-600 text-white px-6 py-2 rounded-lg hover:bg-gray-700 transition font-semibold">
                                طلب تفصيل
                            </button>
                            <button type="button" id="standard-sizes-btn" class="bg-gray-200 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-300 transition font-semibold hidden">
                                القياسات المتوفرة
                            </button>
                        </div>
                    </div>
                    @endif

                    <!-- قسم القياسات المخصصة (يظهر عند اختيار طلب تفصيل) -->
                    @if($product->is_custom)
                    <div id="custom-measurements-section" class="mb-4 {{ $comingFromCartWithCustom ? '' : 'hidden' }}">
                        <div class="bg-white border-2 border-gray-300 rounded-lg p-6">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">أدخل القياسات المطلوبة</h3>
                            
                            @if($product->category_id == 8)
                            <div class="mb-4 p-3 bg-green-50 border border-green-300 rounded-lg">
                                <div class="flex items-center gap-2 text-green-700">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                    <div>
                                        <p class="font-semibold text-sm">السعر بعد إضافة رسوم التفصيل:</p>
                                        <p class="text-lg font-bold">{{ number_format($product->price + 5, 2) }} ر.ع</p>
                                        <p class="text-xs mt-1">(السعر الأساسي: {{ number_format($product->price, 2) }} ر.ع + رسوم تفصيل: 5.00 ر.ع)</p>
                                    </div>
                                </div>
                            </div>
                            @endif
                            
                            <!-- صورة توضيحية للقياسات -->
                            <div class="mb-6 flex justify-center">
                                <div class="bg-gray-100 rounded-lg p-4 border-2 border-dashed border-gray-300">
                                    <img src="{{ asset('images/main/sample.webp') }}" alt="صورة توضيحية للقياسات" class="w-full max-w-md mx-auto rounded-lg">
                                    <p class="text-center text-gray-600 mt-4 text-sm font-semibold">صورة توضيحية للقياسات المطلوبة</p>
                                </div>
                            </div>
                            
                            <!-- حقول القياسات -->
                            <div class="space-y-4">
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">القياس الأول (سم) <span class="text-red-500">*</span></label>
                                    <input type="number" name="measurement_1" id="measurement_1" step="0.1" min="0" placeholder="مثال: 50" 
                                           value="{{ $customMeasurementsFromCart['measurement_1'] ?? '' }}"
                                           class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-primary focus:border-primary" required>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">القياس الثاني (سم) <span class="text-red-500">*</span></label>
                                    <input type="number" name="measurement_2" id="measurement_2" step="0.1" min="0" placeholder="مثال: 40" 
                                           value="{{ $customMeasurementsFromCart['measurement_2'] ?? '' }}"
                                           class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-primary focus:border-primary" required>
                                </div>
                                
                                <div>
                                    <label class="block text-sm font-semibold text-gray-700 mb-2">القياس الثالث (سم) <span class="text-red-500">*</span></label>
                                    <input type="number" name="measurement_3" id="measurement_3" step="0.1" min="0" placeholder="مثال: 30" 
                                           value="{{ $customMeasurementsFromCart['measurement_3'] ?? '' }}"
                                           class="w-full px-4 py-2 border rounded-lg focus:ring-2 focus:ring-primary focus:border-primary" required>
                                </div>
                            </div>
                            
                            <div class="mt-4 p-3 bg-blue-50 border border-blue-200 rounded-lg">
                                <p class="text-sm text-blue-800">
                                    <strong>ملاحظة:</strong> يرجى التأكد من دقة القياسات قبل إرسال الطلب. سيتم التواصل معك لتأكيد الطلب.
                                </p>
                            </div>
                        </div>
                    </div>
                    @endif

                    @if($product->sizes->count() > 0)
                    <div class="mb-4 {{ $comingFromCartWithCustom ? 'hidden' : '' }}" id="standard-sizes-section">
                        <label class="block text-sm font-semibold text-gray-700 mb-3">اختر القياس:</label>
                        <div class="grid grid-cols-2 md:grid-cols-3 gap-3" id="sizes-container">
                            @foreach($product->sizes as $size)
                                @php
                                    $sizeStock = $size->pivot->stock ?? 0;
                                    $sizePrice = $size->pivot->price ?? $product->price;
                                @endphp
                                <label class="relative flex flex-col items-center justify-center p-4 border-2 rounded-lg cursor-pointer transition-all duration-200 {{ $sizeStock > 0 ? 'border-gray-300 hover:border-primary hover:bg-primary/5' : 'border-red-200 opacity-50 cursor-not-allowed' }}" 
                                       data-size-id="{{ $size->id }}" 
                                       data-size-stock="{{ $sizeStock }}"
                                       data-size-price="{{ $sizePrice }}">
                                    <input type="radio" name="size_id" value="{{ $size->id }}" class="absolute opacity-0 size-radio" 
                                           {{ $sizeStock <= 0 ? 'disabled' : '' }}>
                                    <span class="font-bold text-lg text-gray-900 mb-1">{{ $size->name }}</span>
                                    @if($sizePrice != $product->price)
                                        <span class="text-sm text-primary font-bold mb-1">{{ number_format($sizePrice, 2) }} ر.ع</span>
                                    @else
                                        <span class="text-xs text-gray-500 mb-1">{{ number_format($product->price, 2) }} ر.ع</span>
                                    @endif
                                    <span class="text-xs font-medium mt-1 {{ $sizeStock > 0 ? 'text-success' : 'text-red-600' }}">
                                        {{ $sizeStock > 0 ? "متوفر ($sizeStock)" : 'غير متوفر' }}
                                    </span>
                                    <!-- علامة الاختيار -->
                                    <div class="absolute top-2 left-2 rtl:right-2 rtl:left-auto size-check-icon hidden">
                                        <svg class="w-5 h-5 text-primary" fill="currentColor" viewBox="0 0 20 20">
                                            <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                        </svg>
                                    </div>
                                </label>
                            @endforeach
                        </div>
                    </div>
                    @endif

                    @if($actualStock > 0)
                    @php
                        $isEditingFromCart = request()->boolean('from_cart') && request()->has('cart_item');
                    @endphp
                    <form action="{{ route('cart.store') }}" method="POST" id="add-to-cart-form" class="flex flex-col gap-4">
                        @csrf
                        <input type="hidden" name="product_id" value="{{ $product->id }}">
                        <input type="hidden" name="size_id" id="selected-size-id" value="">
                        <input type="hidden" name="cart_item_id" value="{{ request('cart_item') }}">
                        <input type="hidden" name="is_custom_order" id="is-custom-order" value="{{ $comingFromCartWithCustom ? 1 : 0 }}">
                        <input type="hidden" name="custom_measurements" id="custom-measurements-input" value="">
                        <div class="flex gap-4 items-center">
                            <label class="text-sm font-semibold text-gray-700">الكمية:</label>
                            <input type="number" name="quantity" value="1" min="1" max="{{ $actualStock }}" 
                                   class="w-20 px-3 py-2 border rounded" id="quantity-input">
                        </div>
                        <button type="submit" class="bg-primary text-gray-900 px-6 py-2 rounded hover:opacity-90 transition font-semibold">
                            {{ $isEditingFromCart ? 'تحديث المنتج في السلة' : __('messages.add_to_cart') }}
                        </button>
                    </form>
                    @else
                    <button disabled class="bg-gray-400 text-gray-900 px-6 py-2 rounded cursor-not-allowed font-semibold">
                        {{ __('messages.out_of_stock') }}
                    </button>
                    @endif
                </div>
            </div>
        </div>

        @if($relatedProducts->count() > 0)
        <div class="mt-8">
            <h2 class="text-2xl font-semibold mb-4">{{ __('messages.related_products') ?? 'Related Products' }}</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
                @foreach($relatedProducts as $relatedProduct)
                <div class="bg-white rounded-lg shadow overflow-hidden hover:shadow-lg transition">
                    @if($relatedProduct->image)
                    <img src="{{ $relatedProduct->image_url }}" alt="{{ $relatedProduct->name }}" class="w-full h-48 object-cover">
                    @endif
                    <div class="p-4">
                        <h3 class="font-semibold mb-2">{{ $relatedProduct->name }}</h3>
                        <div class="flex justify-between items-center">
                            <span class="text-xl font-bold text-primary">{{ number_format($relatedProduct->price, 2) }} ر.ع</span>
                            <a href="{{ route('products.show', $relatedProduct->id) }}" class="bg-primary text-gray-900 px-4 py-2 rounded hover:opacity-90 transition text-sm font-semibold">
                                {{ __('messages.view_product') }}
                            </a>
                        </div>
                    </div>
                </div>
                @endforeach
            </div>
        </div>
        @endif
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    const customOrderBtn = document.getElementById('custom-order-btn');
    const standardSizesBtn = document.getElementById('standard-sizes-btn');
    const customMeasurementsSection = document.getElementById('custom-measurements-section');
    const standardSizesSection = document.getElementById('standard-sizes-section');
    const isCustomOrderInput = document.getElementById('is-custom-order');
    const customMeasurementsInput = document.getElementById('custom-measurements-input');
    const sizeRadios = document.querySelectorAll('.size-radio');
    const selectedSizeInput = document.getElementById('selected-size-id');
    const quantityInput = document.getElementById('quantity-input');
    const form = document.getElementById('add-to-cart-form');
    const initialSelectedSizeId = "{{ $selectedSizeIdFromCart ?? '' }}";
    
    @if($product->is_custom)
    // تبديل بين طلب التفصيل والقياسات المتوفرة
    if (customOrderBtn) {
        customOrderBtn.addEventListener('click', function() {
            // إظهار قسم القياسات المخصصة
            if (customMeasurementsSection) {
                customMeasurementsSection.classList.remove('hidden');
            }
            // إخفاء قسم القياسات المتوفرة
            if (standardSizesSection) {
                standardSizesSection.classList.add('hidden');
            }
            // تبديل الأزرار
            customOrderBtn.classList.add('hidden');
            if (standardSizesBtn) {
                standardSizesBtn.classList.remove('hidden');
            }
            // تعيين حالة طلب التفصيل
            isCustomOrderInput.value = '1';
            selectedSizeInput.value = '';
        });
    }
    
    if (standardSizesBtn) {
        standardSizesBtn.addEventListener('click', function() {
            // إخفاء قسم القياسات المخصصة
            if (customMeasurementsSection) {
                customMeasurementsSection.classList.add('hidden');
            }
            // إظهار قسم القياسات المتوفرة
            if (standardSizesSection) {
                standardSizesSection.classList.remove('hidden');
            }
            // تبديل الأزرار
            standardSizesBtn.classList.add('hidden');
            if (customOrderBtn) {
                customOrderBtn.classList.remove('hidden');
            }
            // إلغاء حالة طلب التفصيل
            isCustomOrderInput.value = '0';
            customMeasurementsInput.value = '';
        });
    }
    @endif
    
    @if($product->sizes->count() > 0)
    // معالجة اختيار القياسات
    sizeRadios.forEach(radio => {
        radio.addEventListener('change', function() {
            if (this.checked) {
                selectedSizeInput.value = this.value;
                const label = this.closest('label');
                const maxStock = parseInt(label.dataset.sizeStock);
                
                // تحديث الحد الأقصى للكمية
                if (quantityInput) {
                    quantityInput.max = maxStock;
                    if (parseInt(quantityInput.value) > maxStock) {
                        quantityInput.value = maxStock;
                    }
                }
                
                // إزالة التحديد من جميع labels وإضافة للـ label المحدد
                document.querySelectorAll('[data-size-id]').forEach(l => {
                    l.classList.remove('border-primary', 'bg-primary/10', 'ring-2', 'ring-primary', 'ring-offset-2');
                    l.classList.add('border-gray-300');
                    const checkIcon = l.querySelector('.size-check-icon');
                    if (checkIcon) {
                        checkIcon.classList.add('hidden');
                    }
                });
                label.classList.remove('border-gray-300');
                label.classList.add('border-primary', 'bg-primary/10', 'ring-2', 'ring-primary', 'ring-offset-2');
                const checkIcon = label.querySelector('.size-check-icon');
                if (checkIcon) {
                    checkIcon.classList.remove('hidden');
                }
            }
        });
        
        // إضافة تأثير hover عند النقر
        radio.addEventListener('click', function(e) {
            if (!this.disabled) {
                this.checked = true;
                this.dispatchEvent(new Event('change'));
            }
        });
    });
    
    // إضافة تأثير النقر على الـ label بالكامل
    document.querySelectorAll('[data-size-id]').forEach(label => {
        label.addEventListener('click', function(e) {
            const radio = this.querySelector('.size-radio');
            if (radio && !radio.disabled) {
                radio.checked = true;
                radio.dispatchEvent(new Event('change'));
            }
        });
    });
    // إذا جاء المستخدم من السلة ومعه قياس محدد، نحدده تلقائياً
    @if($product->sizes->count() > 0)
    if (initialSelectedSizeId) {
        const preselectedRadio = Array.from(sizeRadios).find(radio => radio.value === initialSelectedSizeId);
        if (preselectedRadio && !preselectedRadio.disabled) {
            preselectedRadio.checked = true;
            preselectedRadio.dispatchEvent(new Event('change'));
        }
    }
    @endif

    @endif
    
    // التحقق قبل الإرسال
    if (form) {
        form.addEventListener('submit', function(e) {
            // تأكد من مزامنة القياس المختار مع الحقل المخفي
            if (!selectedSizeInput.value) {
                const checkedRadio = document.querySelector('.size-radio:checked');
                if (checkedRadio) {
                    selectedSizeInput.value = checkedRadio.value;
                }
            }

            // إذا كان طلب تفصيل
            if (isCustomOrderInput.value === '1') {
                const measurement1 = document.getElementById('measurement_1').value;
                const measurement2 = document.getElementById('measurement_2').value;
                const measurement3 = document.getElementById('measurement_3').value;
                
                if (!measurement1 || !measurement2 || !measurement3) {
                    e.preventDefault();
                    if (typeof showNotification !== 'undefined') {
                        showNotification('يرجى إدخال جميع القياسات المطلوبة', 'error');
                    } else {
                        alert('يرجى إدخال جميع القياسات المطلوبة');
                    }
                    return false;
                }
                
                // حفظ القياسات في hidden input
                customMeasurementsInput.value = JSON.stringify({
                    measurement_1: measurement1,
                    measurement_2: measurement2,
                    measurement_3: measurement3
                });
            } else {
                // إذا كان منتج عادي مع قياسات
                @if($product->sizes->count() > 0)
                if (!selectedSizeInput.value) {
                    e.preventDefault();
                    if (typeof showNotification !== 'undefined') {
                        showNotification('يرجى اختيار قياس للمنتج قبل الإضافة إلى السلة', 'error');
                    } else {
                        alert('يرجى اختيار قياس للمنتج قبل الإضافة إلى السلة');
                    }
                    return false;
                }
                @endif
            }
        });
    }
});
</script>
@endsection

