@extends('layouts.app')

@section('title', __('messages.products'))

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="py-8">
        <h1 class="text-3xl font-bold mb-6">{{ __('messages.products') }}</h1>
        
        <div class="flex flex-col md:flex-row gap-4 mb-6">
            <form method="GET" action="{{ route('products.index') }}" class="flex-1">
                <input type="text" name="search" value="{{ request('search') }}" placeholder="{{ __('messages.search_products') }}" 
                       class="w-full px-4 py-2 border rounded-lg">
                @if(request('category_id'))
                <input type="hidden" name="category_id" value="{{ request('category_id') }}">
                @endif
            </form>
            
            <select name="category_id" onchange="window.location.href='{{ route('products.index') }}?category_id='+this.value" 
                    class="px-4 py-2 border rounded-lg">
                <option value="">{{ __('messages.all_categories') }}</option>
                @foreach($categories as $category)
                <option value="{{ $category->id }}" {{ request('category_id') == $category->id ? 'selected' : '' }}>
                    {{ $category->name }}
                </option>
                @endforeach
            </select>
        </div>

        @if($products->count() > 0)
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            @foreach($products as $product)
            <div class="bg-white rounded-lg shadow overflow-hidden hover:shadow-lg transition">
                @if($product->image)
                <img src="{{ $product->image_url }}" alt="{{ $product->name }}" class="w-full h-48 object-cover">
                @else
                <div class="w-full h-48 bg-gray-200 flex items-center justify-center">
                    <span class="text-gray-400">{{ __('messages.no_image') ?? 'No Image' }}</span>
                </div>
                @endif
                <div class="p-4">
                    <h3 class="font-semibold text-lg mb-2">{{ $product->name }}</h3>
                    <p class="text-gray-600 text-sm mb-2">{{ Str::limit($product->description, 50) }}</p>
                    <div class="flex justify-between items-center mb-2">
                        <span class="text-xl font-bold text-primary">{{ number_format($product->price, 2) }} ر.ع</span>
                        @if($product->points_earned > 0)
                        <span class="text-sm text-success">+{{ $product->points_earned }} {{ __('messages.points') }}</span>
                        @endif
                    </div>
                    <div class="space-y-2">
                        <div class="flex justify-between items-center">
                            <span class="text-sm {{ $product->stock > 0 ? 'text-success' : 'text-primary' }}">
                                {{ $product->stock > 0 ? __('messages.in_stock') : __('messages.out_of_stock') }}
                            </span>
                        </div>
                        <a href="{{ route('products.show', $product->id) }}" class="block w-full text-center border-2 border-primary text-primary py-2 rounded-lg hover:bg-primary-light/10 transition font-semibold">
                            {{ __('messages.view_details') ?? 'عرض التفاصيل' }}
                        </a>
                    </div>
                </div>
            </div>
            @endforeach
        </div>

        <div class="mt-6">
            {{ $products->links() }}
        </div>
        @else
        <p class="text-gray-500 text-center py-8">{{ __('messages.no_products') ?? 'No products found' }}</p>
        @endif
    </div>
</div>
@endsection

