@extends('layouts.app')

@section('title', __('messages.order_details'))

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="py-8">
        <h1 class="text-3xl font-bold mb-6">{{ __('messages.order_details') }}</h1>
        
        <div class="bg-white rounded-lg shadow p-6 mb-6">
            <div class="grid md:grid-cols-2 gap-6 mb-6">
                <div>
                    <h3 class="font-semibold mb-2">{{ __('messages.order_number') }}</h3>
                    <p class="text-gray-600">{{ $order->order_number }}</p>
                </div>
                <div>
                    <h3 class="font-semibold mb-2">{{ __('messages.order_status') }}</h3>
                    <span class="px-3 py-1 rounded-full text-sm font-medium
                        @if($order->status === 'pending') bg-yellow-100 text-yellow-800
                        @elseif($order->status === 'processing') bg-primary-light/30 text-primary
                        @elseif($order->status === 'shipped') bg-secondary/30 text-secondary
                        @elseif($order->status === 'delivered') bg-success/30 text-success
                        @else bg-primary/20 text-primary
                        @endif">
                        {{ __('messages.' . $order->status) }}
                    </span>
                </div>
                <div>
                    <h3 class="font-semibold mb-2">{{ __('messages.order_date') }}</h3>
                    <p class="text-gray-600">{{ $order->created_at->format('Y-m-d H:i') }}</p>
                </div>
                <div>
                    <h3 class="font-semibold mb-2">{{ __('messages.total') }}</h3>
                    <p class="text-gray-600 text-xl font-bold">{{ number_format($order->total_amount, 2) }} ر.ع</p>
                    @if($order->points_earned > 0)
                    <p class="text-sm text-success mt-1">{{ __('messages.points_earned') }}: +{{ $order->points_earned }} {{ __('messages.points') }}</p>
                    @endif
                </div>
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6 mb-6">
            <h2 class="text-xl font-semibold mb-4">{{ __('messages.shipping_address') }}</h2>
            <div class="space-y-2">
                <p><strong>{{ __('messages.shipping_name') }}:</strong> {{ $order->shipping_name }}</p>
                <p><strong>{{ __('messages.shipping_phone') }}:</strong> {{ $order->shipping_phone }}</p>
                <p><strong>{{ __('messages.shipping_city') }}:</strong> {{ $order->shipping_city }}</p>
                <p><strong>{{ __('messages.shipping_address') }}:</strong> {{ $order->shipping_address }}</p>
                @if($order->notes)
                <p><strong>{{ __('messages.notes') }}:</strong> {{ $order->notes }}</p>
                @endif
            </div>
        </div>

        <div class="bg-white rounded-lg shadow p-6">
            <h2 class="text-xl font-semibold mb-4">{{ __('messages.order_items') ?? 'Order Items' }}</h2>
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">{{ __('messages.product_name') }}</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">{{ __('messages.price') }}</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">{{ __('messages.quantity') }}</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">{{ __('messages.subtotal') }}</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($order->items as $item)
                    @php
                        // استخراج اسم المنتج والقياس من product_name (للطلبات القديمة)
                        $productName = $item->product->name ?? $item->product_name ?? 'منتج محذوف';
                        $sizeNameFromProductName = null;
                        
                        // إذا كان product_name يحتوي على " - " (للطلبات القديمة)
                        if ($item->product_name && str_contains($item->product_name, ' - ')) {
                            $parts = explode(' - ', $item->product_name);
                            if (count($parts) > 1) {
                                $productName = trim($parts[0]);
                                $sizeNameFromProductName = trim($parts[1]);
                            }
                        }
                    @endphp
                    <tr>
                        <td class="px-6 py-4">
                            <div class="text-sm font-medium text-gray-900">{{ $productName }}</div>
                            
                            @if($item->size)
                            <div class="mt-1 text-xs text-gray-600">
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-gray-100 text-gray-700">
                                    <span class="ml-1 rtl:mr-1 rtl:ml-0 font-semibold">القياس:</span>
                                    <span>{{ $item->size->name }}</span>
                                </span>
                            </div>
                            @elseif($sizeNameFromProductName)
                            <div class="mt-1 text-xs text-gray-600">
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-gray-100 text-gray-700">
                                    <span class="ml-1 rtl:mr-1 rtl:ml-0 font-semibold">القياس:</span>
                                    <span>{{ $sizeNameFromProductName }}</span>
                                </span>
                            </div>
                            @endif
                            
                            @if($item->custom_measurements && is_array($item->custom_measurements) && !empty(array_filter($item->custom_measurements)))
                            <div class="mt-2 p-2 bg-purple-50 border border-purple-200 rounded text-xs">
                                <div class="flex items-center gap-1 mb-1">
                                    <svg class="w-3 h-3 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                    <span class="font-semibold text-purple-800">قياسات التفصيل:</span>
                                </div>
                                <div class="text-purple-700 space-y-0.5">
                                    @if(!empty($item->custom_measurements['measurement_1'] ?? null))
                                    <div>القياس الأول: <span class="font-semibold">{{ $item->custom_measurements['measurement_1'] }} سم</span></div>
                                    @endif
                                    @if(!empty($item->custom_measurements['measurement_2'] ?? null))
                                    <div>القياس الثاني: <span class="font-semibold">{{ $item->custom_measurements['measurement_2'] }} سم</span></div>
                                    @endif
                                    @if(!empty($item->custom_measurements['measurement_3'] ?? null))
                                    <div>القياس الثالث: <span class="font-semibold">{{ $item->custom_measurements['measurement_3'] }} سم</span></div>
                                    @endif
                                </div>
                            </div>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ number_format($item->price, 2) }} ر.ع</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">{{ $item->quantity }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">{{ number_format($item->subtotal, 2) }} ر.ع</td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="bg-gray-50">
                    <tr>
                        <td colspan="3" class="px-6 py-4 text-right text-sm font-medium text-gray-900">{{ __('messages.total') }}</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-900">{{ number_format($order->total_amount, 2) }} ر.ع</td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
@endsection





