@extends('layouts.app')

@section('title', __('messages.orders'))

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="py-8">
        <h1 class="text-3xl font-bold mb-6">{{ __('messages.order_history') }}</h1>
        
        @if($orders->count() > 0)
        <div class="space-y-4">
            @foreach($orders as $order)
            <div class="bg-white rounded-lg shadow p-6">
                <div class="flex justify-between items-start mb-4">
                    <div>
                        <h3 class="text-lg font-semibold">{{ __('messages.order_number') }}: {{ $order->order_number }}</h3>
                        <p class="text-sm text-gray-500">{{ __('messages.order_date') }}: {{ $order->created_at->format('Y-m-d H:i') }}</p>
                    </div>
                    <div class="text-right rtl:text-left">
                        <span class="px-3 py-1 rounded-full text-sm font-medium
                            @if($order->status === 'pending') bg-yellow-100 text-yellow-800
                            @elseif($order->status === 'processing') bg-primary-light/30 text-primary
                            @elseif($order->status === 'shipped') bg-secondary/30 text-secondary
                            @elseif($order->status === 'delivered') bg-success/30 text-success
                            @else bg-primary/20 text-primary
                            @endif">
                            {{ __('messages.' . $order->status) }}
                        </span>
                    </div>
                </div>
                
                <div class="mb-4">
                    <p class="text-lg font-bold">{{ __('messages.total') }}: {{ number_format($order->total_amount, 2) }} ر.ع</p>
                    @if($order->points_earned > 0)
                    <p class="text-sm text-success">{{ __('messages.points_earned') }}: +{{ $order->points_earned }} {{ __('messages.points') }}</p>
                    @endif
                </div>
                
                <div class="flex justify-between">
                    <a href="{{ route('orders.show', $order->id) }}" class="text-primary hover:opacity-80">
                        {{ __('messages.order_details') }}
                    </a>
                    <a href="{{ route('orders.track', ['order_number' => $order->order_number]) }}" class="text-primary hover:opacity-80">
                        {{ __('messages.track_order') }}
                    </a>
                </div>
            </div>
            @endforeach
        </div>
        @else
        <div class="bg-white rounded-lg shadow p-8 text-center">
            <p class="text-gray-500">{{ __('messages.no_orders') }}</p>
            <a href="{{ route('products.index') }}" class="mt-4 bg-primary text-white px-6 py-2 rounded hover:opacity-90 transition inline-block">
                {{ __('messages.continue_shopping') }}
            </a>
        </div>
        @endif
    </div>
</div>
@endsection





