@extends('layouts.app')

@section('title', __('messages.home'))

@section('content')
<!-- Static Images Section -->
@php
    $sliders = \App\Models\Slider::where('is_active', true)->orderBy('order')->limit(3)->get();
@endphp
<div class="relative w-full overflow-hidden" style="height: 500px;">
    @if($sliders->count() > 0)
    <div class="relative w-full h-full px-4">
        <div class="flex h-full gap-4">
            @foreach($sliders as $slider)
            <div class="flex-1 h-full">
                <div class="relative w-full h-full rounded-lg overflow-hidden shadow-lg">
            @if($slider->link)
                    <a href="{{ $slider->link }}" class="block h-full">
            @endif
                <img src="{{ $slider->image_url }}" alt="{{ $slider->title }}" class="w-full h-full object-cover">
                @if($slider->title || $slider->description)
                        <div class="absolute inset-0 bg-black/40 flex items-center justify-center p-4">
                            <div class="text-center text-white">
                        @if($slider->title)
                                <h2 class="text-2xl md:text-3xl font-bold mb-2">{{ $slider->title }}</h2>
                        @endif
                        @if($slider->description)
                                <p class="text-sm md:text-base opacity-90">{{ $slider->description }}</p>
                        @endif
                    </div>
                </div>
                @endif
            @if($slider->link)
            </a>
            @endif
                </div>
        </div>
        @endforeach
    </div>
    </div>
    @else
    <!-- Hero Banner Section (Fallback) -->
    <div class="absolute inset-0 bg-gradient-to-r from-primary to-secondary text-white flex items-center">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 w-full text-center">
            <h1 class="text-4xl md:text-6xl font-bold mb-4">{{ __('messages.welcome') }} {{ __('messages.to') ?? 'to' }} {{ config('app.name') }}</h1>
            <p class="text-xl md:text-2xl mb-8 opacity-90">{{ __('messages.discover_amazing_products') ?? 'Discover amazing products at great prices' }}</p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="{{ route('products.index') }}" class="bg-white text-primary px-8 py-3 rounded-lg font-semibold hover:bg-gray-100 transition shadow-lg">
                    {{ __('messages.shop_now') ?? 'Shop Now' }}
                </a>
                <a href="{{ route('products.index') }}" class="bg-transparent border-2 border-white text-white px-8 py-3 rounded-lg font-semibold hover:bg-white hover:text-primary transition">
                    {{ __('messages.browse_products') ?? 'Browse Products' }}
                </a>
            </div>
        </div>
    </div>
    @endif
</div>

<!-- Categories Section -->
@if($categories->count() > 0)
<div class="bg-white py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center mb-8">
            <h2 class="text-3xl font-bold text-gray-900">{{ __('messages.shop_by_category') ?? 'Shop by Category' }}</h2>
            <a href="{{ route('products.index') }}" class="text-primary hover:opacity-80 font-semibold">
                {{ __('messages.view_all') ?? 'View All' }} →
            </a>
        </div>
        <div class="grid grid-cols-2 sm:grid-cols-4 lg:grid-cols-8 gap-4">
            @foreach($categories as $category)
            <a href="{{ route('products.index', ['category_id' => $category->id]) }}" class="group bg-white rounded-lg shadow-md hover:shadow-xl transition-all duration-300 p-4 text-center transform hover:-translate-y-1">
                    @if($category->image)
                    <div class="w-20 h-20 mx-auto mb-3 rounded-full overflow-hidden bg-gray-100">
                        <img src="{{ $category->image_url }}" alt="{{ $category->name }}" class="w-full h-full object-cover group-hover:scale-110 transition-transform duration-300">
                    </div>
                    @else
                <div class="w-20 h-20 mx-auto mb-3 rounded-full bg-gradient-to-br from-primary-light to-primary flex items-center justify-center">
                    <svg class="w-10 h-10 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                </div>
                @endif
                <h3 class="font-semibold text-gray-800 group-hover:text-primary transition">{{ $category->name }}</h3>
            </a>
            @endforeach
        </div>
    </div>
</div>
@endif

<!-- Featured Products Section -->
@if($featuredProducts->count() > 0)
<div class="bg-gray-50 py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center mb-8">
            <h2 class="text-3xl font-bold text-gray-900">{{ __('messages.featured_products') ?? 'Featured Products' }}</h2>
            <a href="{{ route('products.index') }}" class="text-primary hover:opacity-80 font-semibold">
                {{ __('messages.view_all') ?? 'View All' }} →
            </a>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            @foreach($featuredProducts as $product)
            <div class="bg-white rounded-lg shadow-md hover:shadow-xl transition-all duration-300 overflow-hidden group">
                <div class="relative overflow-hidden">
                    @if($product->image)
                    <img src="{{ $product->image_url }}" alt="{{ $product->name }}" class="w-full h-64 object-cover group-hover:scale-110 transition-transform duration-300">
                    @else
                    <div class="w-full h-64 bg-gradient-to-br from-gray-200 to-gray-300 flex items-center justify-center">
                        <svg class="w-20 h-20 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    @endif
                    @if($product->points_earned > 0)
                    <div class="absolute top-2 right-2 bg-success text-white px-2 py-1 rounded-full text-xs font-bold">
                        +{{ $product->points_earned }} {{ __('messages.points') }}
                    </div>
                    @endif
                    @if($product->stock <= 5 && $product->stock > 0)
                    <div class="absolute top-2 left-2 bg-primary text-white px-2 py-1 rounded-full text-xs font-bold">
                        {{ __('messages.limited_stock') ?? 'Limited Stock' }}
                    </div>
                    @endif
                </div>
                <div class="p-4">
                    <div class="mb-2">
                        <span class="text-xs text-gray-500">{{ $product->category->name ?? '' }}</span>
                    </div>
                    <h3 class="font-semibold text-lg mb-2 text-gray-900 line-clamp-2">{{ $product->name }}</h3>
                    <p class="text-gray-600 text-sm mb-3 line-clamp-2">{{ Str::limit($product->description, 60) }}</p>
                    <div class="flex items-center justify-between mb-3">
                        <div>
                            <span class="text-2xl font-bold text-primary">{{ number_format($product->price, 2) }} ر.ع</span>
                        </div>
                        <div class="text-sm {{ $product->stock > 0 ? 'text-success' : 'text-primary' }}">
                            @if($product->stock > 0)
                                <span class="inline-flex items-center">
                                    <svg class="w-4 h-4 mr-1" fill="currentColor" viewBox="0 0 20 20">
                                        <path fill-rule="evenodd" d="M10 18a8 8 0 100-16 8 8 0 000 16zm3.707-9.293a1 1 0 00-1.414-1.414L9 10.586 7.707 9.293a1 1 0 00-1.414 1.414l2 2a1 1 0 001.414 0l4-4z" clip-rule="evenodd"></path>
                                    </svg>
                                    {{ __('messages.in_stock') }}
                                </span>
                            @else
                                <span>{{ __('messages.out_of_stock') }}</span>
                            @endif
                        </div>
                    </div>
                    @if($product->stock > 0)
                    <form action="{{ route('cart.store') }}" method="POST" class="mb-2">
                        @csrf
                        <input type="hidden" name="product_id" value="{{ $product->id }}">
                        <input type="hidden" name="quantity" value="1">
                        <button type="submit" class="w-full bg-primary text-gray-900 py-2 rounded-lg hover:opacity-90 transition font-semibold">
                            {{ __('messages.add_to_cart') }}
                        </button>
                    </form>
                    @endif
                    <a href="{{ route('products.show', $product->id) }}" class="block w-full text-center border-2 border-primary text-primary py-2 rounded-lg hover:bg-primary-light/10 transition font-semibold">
                        {{ __('messages.view_details') ?? 'View Details' }}
                    </a>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endif

<!-- New Arrivals Section -->
@if($newProducts->count() > 0)
<div class="bg-white py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-between items-center mb-8">
            <h2 class="text-3xl font-bold text-gray-900">{{ __('messages.new_arrivals') ?? 'New Arrivals' }}</h2>
            <a href="{{ route('products.index') }}" class="text-primary hover:opacity-80 font-semibold">
                {{ __('messages.view_all') ?? 'View All' }} →
            </a>
        </div>
        <div class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-4 gap-6">
            @foreach($newProducts as $product)
            <div class="bg-white rounded-lg shadow-md hover:shadow-xl transition-all duration-300 overflow-hidden group border border-gray-100">
                <div class="relative overflow-hidden">
                    @if($product->image)
                    <img src="{{ $product->image_url }}" alt="{{ $product->name }}" class="w-full h-64 object-cover group-hover:scale-110 transition-transform duration-300">
                    @else
                    <div class="w-full h-64 bg-gradient-to-br from-gray-200 to-gray-300 flex items-center justify-center">
                        <svg class="w-20 h-20 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                        </svg>
                    </div>
                    @endif
                    <div class="absolute top-2 left-2 bg-secondary text-white px-2 py-1 rounded-full text-xs font-bold">
                        {{ __('messages.new') ?? 'NEW' }}
                    </div>
                </div>
                <div class="p-4">
                    <h3 class="font-semibold text-lg mb-2 text-gray-900 line-clamp-2">{{ $product->name }}</h3>
                    <div class="flex items-center justify-between mb-3">
                        <span class="text-2xl font-bold text-primary">{{ number_format($product->price, 2) }} ر.س</span>
                    </div>
                    <a href="{{ route('products.show', $product->id) }}" class="block w-full text-center bg-primary text-white py-2 rounded-lg hover:opacity-90 transition font-semibold">
                        {{ __('messages.view_product') }}
                    </a>
                </div>
            </div>
            @endforeach
        </div>
    </div>
</div>
@endif

<!-- Features Section -->
<div class="bg-gray-50 py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="text-center">
                <div class="bg-primary-light/20 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-primary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold mb-2">{{ __('messages.free_shipping') ?? 'Free Shipping' }}</h3>
                <p class="text-gray-600">{{ __('messages.free_shipping_desc') ?? 'On orders over 100 OMR' }}</p>
            </div>
            <div class="text-center">
                <div class="bg-success/20 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-success" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold mb-2">{{ __('messages.secure_payment') ?? 'Secure Payment' }}</h3>
                <p class="text-gray-600">{{ __('messages.secure_payment_desc') ?? '100% secure payment methods' }}</p>
            </div>
            <div class="text-center">
                <div class="bg-secondary/20 w-16 h-16 rounded-full flex items-center justify-center mx-auto mb-4">
                    <svg class="w-8 h-8 text-secondary" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
                <h3 class="text-xl font-semibold mb-2">{{ __('messages.earn_points') ?? 'Earn Points' }}</h3>
                <p class="text-gray-600">{{ __('messages.earn_points_desc') ?? 'Get points with every purchase' }}</p>
            </div>
        </div>
    </div>
</div>

<!-- Newsletter Section -->
<div class="bg-gradient-to-r from-primary to-secondary text-white py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-3xl font-bold mb-4">{{ __('messages.stay_updated') ?? 'Stay Updated' }}</h2>
        <p class="text-xl mb-6 opacity-90">{{ __('messages.newsletter_desc') ?? 'Subscribe to get special offers and updates' }}</p>
        <form class="max-w-md mx-auto flex gap-2">
            <input type="email" placeholder="{{ __('messages.your_email') ?? 'Your email' }}" class="flex-1 px-4 py-3 rounded-lg text-gray-900 focus:outline-none focus:ring-2 focus:ring-white">
            <button type="submit" class="bg-white text-primary px-6 py-3 rounded-lg font-semibold hover:bg-gray-100 transition">
                {{ __('messages.subscribe') ?? 'Subscribe' }}
            </button>
        </form>
    </div>
</div>
@endsection
