<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}" dir="{{ app()->getLocale() === 'ar' ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>{{ app()->getLocale() === 'ar' ? 'تأكيد الطلب' : 'Order Confirmation' }}</title>
    <style>
        body {
            font-family: {{ app()->getLocale() === 'ar' ? 'Cairo, Arial' : 'Inter, Arial' }}, sans-serif;
            line-height: 1.6;
            color: #333;
            max-width: 600px;
            margin: 0 auto;
            padding: 20px;
            background-color: #f5f5f5;
        }
        .container {
            background-color: #ffffff;
            border-radius: 8px;
            padding: 30px;
            box-shadow: 0 2px 4px rgba(0,0,0,0.1);
        }
        .header {
            text-align: center;
            border-bottom: 2px solid #ff3131;
            padding-bottom: 20px;
            margin-bottom: 30px;
        }
        .header h1 {
            color: #ff3131;
            margin: 0;
            font-size: 24px;
        }
        .order-info {
            background-color: #f9f9f9;
            padding: 20px;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .order-info h2 {
            color: #1e9a8e;
            margin-top: 0;
        }
        .info-row {
            display: flex;
            justify-content: space-between;
            padding: 8px 0;
            border-bottom: 1px solid #eee;
        }
        .info-row:last-child {
            border-bottom: none;
        }
        .info-label {
            font-weight: bold;
            color: #666;
        }
        .info-value {
            color: #333;
        }
        .items-table {
            width: 100%;
            border-collapse: collapse;
            margin: 20px 0;
        }
        .items-table th,
        .items-table td {
            padding: 12px;
            text-align: {{ app()->getLocale() === 'ar' ? 'right' : 'left' }};
            border-bottom: 1px solid #eee;
        }
        .items-table th {
            background-color: #1e9a8e;
            color: white;
        }
        .items-table tr:hover {
            background-color: #f9f9f9;
        }
        .total {
            text-align: {{ app()->getLocale() === 'ar' ? 'left' : 'right' }};
            font-size: 18px;
            font-weight: bold;
            color: #ff3131;
            margin-top: 20px;
        }
        .footer {
            text-align: center;
            margin-top: 30px;
            padding-top: 20px;
            border-top: 1px solid #eee;
            color: #666;
            font-size: 14px;
        }
        .button {
            display: inline-block;
            padding: 12px 30px;
            background-color: #ff3131;
            color: white;
            text-decoration: none;
            border-radius: 5px;
            margin-top: 20px;
        }
        .button:hover {
            background-color: #ff8a81;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <h1>{{ app()->getLocale() === 'ar' ? 'شكراً لك على طلبك!' : 'Thank You for Your Order!' }}</h1>
        </div>

        <div class="order-info">
            <h2>{{ app()->getLocale() === 'ar' ? 'معلومات الطلب' : 'Order Information' }}</h2>
            <div class="info-row">
                <span class="info-label">{{ app()->getLocale() === 'ar' ? 'رقم الطلب:' : 'Order Number:' }}</span>
                <span class="info-value"><strong>#{{ $order->order_number }}</strong></span>
            </div>
            <div class="info-row">
                <span class="info-label">{{ app()->getLocale() === 'ar' ? 'تاريخ الطلب:' : 'Order Date:' }}</span>
                <span class="info-value">{{ $order->created_at->format('Y-m-d H:i') }}</span>
            </div>
            <div class="info-row">
                <span class="info-label">{{ app()->getLocale() === 'ar' ? 'الحالة:' : 'Status:' }}</span>
                <span class="info-value">{{ __('messages.' . $order->status) ?? ucfirst($order->status) }}</span>
            </div>
            @if($order->points_earned > 0)
            <div class="info-row">
                <span class="info-label">{{ app()->getLocale() === 'ar' ? 'النقاط المكتسبة:' : 'Points Earned:' }}</span>
                <span class="info-value" style="color: #76c791;">+{{ $order->points_earned }} {{ __('messages.points') }}</span>
            </div>
            @endif
        </div>

        <h3>{{ app()->getLocale() === 'ar' ? 'عناصر الطلب' : 'Order Items' }}</h3>
        <table class="items-table">
            <thead>
                <tr>
                    <th>{{ app()->getLocale() === 'ar' ? 'المنتج' : 'Product' }}</th>
                    <th>{{ app()->getLocale() === 'ar' ? 'الكمية' : 'Quantity' }}</th>
                    <th>{{ app()->getLocale() === 'ar' ? 'السعر' : 'Price' }}</th>
                    <th>{{ app()->getLocale() === 'ar' ? 'المجموع' : 'Subtotal' }}</th>
                </tr>
            </thead>
            <tbody>
                @foreach($order->items as $item)
                <tr>
                    <td>{{ $item->product_name }}</td>
                    <td>{{ $item->quantity }}</td>
                    <td>{{ number_format($item->price, 2) }} {{ app()->getLocale() === 'ar' ? 'ر.ع' : 'OMR' }}</td>
                    <td>{{ number_format($item->subtotal, 2) }} {{ app()->getLocale() === 'ar' ? 'ر.ع' : 'OMR' }}</td>
                </tr>
                @endforeach
            </tbody>
        </table>

        <div class="total">
            {{ app()->getLocale() === 'ar' ? 'الإجمالي:' : 'Total:' }} {{ number_format($order->total_amount, 2) }} {{ app()->getLocale() === 'ar' ? 'ر.ع' : 'OMR' }}
        </div>

        <div class="order-info" style="margin-top: 30px;">
            <h2>{{ app()->getLocale() === 'ar' ? 'عنوان الشحن' : 'Shipping Address' }}</h2>
            <p><strong>{{ $order->shipping_name }}</strong></p>
            <p>{{ $order->shipping_address }}</p>
            <p>{{ $order->shipping_city }}</p>
            <p>{{ app()->getLocale() === 'ar' ? 'الهاتف:' : 'Phone:' }} {{ $order->shipping_phone }}</p>
        </div>

        <div style="text-align: center; margin-top: 30px;">
            <a href="{{ route('orders.show', $order->id) }}" class="button">
                {{ app()->getLocale() === 'ar' ? 'عرض تفاصيل الطلب' : 'View Order Details' }}
            </a>
        </div>

        <div class="footer">
            <p>{{ app()->getLocale() === 'ar' ? 'شكراً لك على اختيارنا!' : 'Thank you for choosing us!' }}</p>
            <p>&copy; {{ date('Y') }} {{ config('app.name') }}. {{ __('messages.all_rights_reserved') ?? 'All rights reserved' }}.</p>
        </div>
    </div>
</body>
</html>

