@extends('layouts.app')

@section('title', __('messages.cart'))

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
    <div class="py-8">
        <h1 class="text-3xl font-bold mb-6">{{ __('messages.cart') }}</h1>
        
        @if($cartItems->count() > 0)
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('messages.product_name') }}</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('messages.price') }}</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('messages.quantity') }}</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">{{ __('messages.subtotal') }}</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider"></th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($cartItems as $item)
                    @php
                        $product = is_array($item) ? $item['product'] : $item->product;
                        $quantity = is_array($item) ? $item['quantity'] : $item->quantity;
                        $itemId = is_array($item) ? $item['id'] : $item->id;
                        $size   = is_array($item) ? ($item['size'] ?? null) : ($item->size ?? null);
                        $customMeasurements = is_array($item) ? ($item['custom_measurements'] ?? null) : ($item->custom_measurements ?? null);
                        $cmParam = $customMeasurements ? base64_encode(json_encode($customMeasurements)) : null;
                        $cartItemParam = $itemId;
                    @endphp
                    <tr>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <a href="{{ route('products.show', ['id' => $product->id, 'size_id' => $size?->id, 'from_cart' => 1, 'cm' => $cmParam, 'cart_item' => $cartItemParam]) }}" class="flex items-center group">
                                @if($product->image)
                                <img src="{{ $product->image_url }}" alt="{{ $product->name }}" class="h-16 w-16 object-cover rounded border border-gray-200 group-hover:border-primary transition">
                                @endif
                                <div class="mr-4 rtl:ml-4 rtl:mr-0">
                                    <div class="text-sm font-medium text-gray-900 group-hover:text-primary transition">
                                        {{ $product->name }}
                                    </div>
                                    
                                    @if($size)
                                    <div class="mt-1 inline-flex items-center px-2 py-0.5 rounded-full bg-gray-100 text-xs text-gray-700">
                                        <span class="ml-1 rtl:mr-1 rtl:ml-0 font-semibold">القياس:</span>
                                        <span>{{ $size->name }}</span>
                                    </div>
                                    @endif
                                    
                                    @if($product->is_custom)
                                    <div class="mt-1 text-[11px] text-purple-700">
                                        منتج تفصيل - يمكن تعديل القياسات من صفحة المنتج
                                    </div>
                                    
                                    @if($customMeasurements && is_array($customMeasurements))
                                    <div class="mt-1 text-[11px] text-gray-600">
                                        قياساتك الحالية:
                                        @php
                                            $m1 = $customMeasurements['measurement_1'] ?? null;
                                            $m2 = $customMeasurements['measurement_2'] ?? null;
                                            $m3 = $customMeasurements['measurement_3'] ?? null;
                                        @endphp
                                        @if($m1) الطول: <span class="font-semibold">{{ $m1 }} سم</span>@endif
                                        @if($m2) ، العرض: <span class="font-semibold">{{ $m2 }} سم</span>@endif
                                        @if($m3) ، العمق: <span class="font-semibold">{{ $m3 }} سم</span>@endif
                                    </div>
                                    @endif
                                    @endif
                                </div>
                            </a>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            @php
                                $itemPrice = $product->price;
                                // إذا كان التصنيف 8 واختار العميل تفصيل، أضف 5 ريال
                                if ($product->category_id == 8 && $customMeasurements) {
                                    $itemPrice += 5;
                                }
                            @endphp
                            {{ number_format($itemPrice, 2) }} ر.ع
                            @if($product->category_id == 8 && $customMeasurements)
                                <span class="block text-xs text-green-600 mt-1">+5 ر.ع رسوم تفصيل</span>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap">
                            <form action="{{ route('cart.update', $itemId) }}" method="POST" class="inline">
                                @csrf
                                @method('PUT')
                                <input type="number" name="quantity" value="{{ $quantity }}" min="1" max="{{ $product->stock }}" 
                                       class="w-20 px-2 py-1 border rounded" onchange="this.form.submit()">
                            </form>
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                            {{ number_format($quantity * $itemPrice, 2) }} ر.ع
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-right text-sm font-medium">
                            <form action="{{ route('cart.destroy', $itemId) }}" method="POST" class="inline">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="text-primary hover:opacity-80">{{ __('messages.remove_from_cart') }}</button>
                            </form>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="bg-gray-50">
                    <tr>
                        <td colspan="3" class="px-6 py-4 text-right text-sm font-medium text-gray-900">
                            {{ __('messages.total') }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-900">
                            {{ number_format($total, 2) }} ر.ع
                        </td>
                        <td></td>
                    </tr>
                </tfoot>
            </table>
        </div>

        <div class="mt-6 flex justify-between">
            <a href="{{ route('products.index') }}" class="bg-gray-500 text-white px-6 py-2 rounded hover:bg-gray-600 transition">
                {{ __('messages.continue_shopping') }}
            </a>
            @auth
            <a href="{{ route('orders.create') }}" class="bg-primary text-white px-6 py-2 rounded hover:opacity-90 transition">
                {{ __('messages.checkout') }}
            </a>
            @else
            <a href="{{ route('login', ['redirect' => route('orders.create'), 'lang' => 'ar']) }}" class="bg-primary text-white px-6 py-2 rounded hover:opacity-90 transition">
                {{ __('messages.login_to_checkout') ?? 'Login to Checkout' }}
            </a>
            @endauth
        </div>
        @else
        <div class="bg-white rounded-lg shadow p-8 text-center">
            <p class="text-gray-500 mb-4">{{ __('messages.cart_empty') }}</p>
            <a href="{{ route('products.index') }}" class="bg-primary text-white px-6 py-2 rounded hover:opacity-90 transition inline-block">
                {{ __('messages.continue_shopping') }}
            </a>
        </div>
        @endif
    </div>
</div>
@endsection

