@extends('layouts.app')

@section('title', 'تعديل السلايدر')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-6">
        <a href="{{ route('admin.sliders.index') }}" class="text-primary hover:opacity-80">← رجوع</a>
    </div>

    <h1 class="text-3xl font-bold text-gray-900 mb-6">تعديل السلايدر</h1>

    @php
        $activeCount = \App\Models\Slider::where('is_active', true)->where('id', '!=', $slider->id)->count();
    @endphp
    
    @if($activeCount >= 3 && !$slider->is_active)
        <div class="bg-yellow-50 border-r-4 border-yellow-400 p-4 mb-6">
            <div class="flex">
                <div class="flex-shrink-0">
                    <svg class="h-5 w-5 text-yellow-400" fill="currentColor" viewBox="0 0 20 20">
                        <path fill-rule="evenodd" d="M8.257 3.099c.765-1.36 2.722-1.36 3.486 0l5.58 9.92c.75 1.334-.213 2.98-1.742 2.98H4.42c-1.53 0-2.493-1.646-1.743-2.98l5.58-9.92zM11 13a1 1 0 11-2 0 1 1 0 012 0zm-1-8a1 1 0 00-1 1v3a1 1 0 002 0V6a1 1 0 00-1-1z" clip-rule="evenodd"/>
                    </svg>
                </div>
                <div class="mr-3">
                    <p class="text-sm text-yellow-700">
                        <strong>تنبيه:</strong> يوجد حالياً 3 صور نشطة. لا يمكن تفعيل هذه الصورة إلا بعد تعطيل إحدى الصور الأخرى.
                    </p>
                </div>
            </div>
        </div>
    @endif

    <div class="bg-white rounded-lg shadow p-6">
        <form action="{{ route('admin.sliders.update', $slider->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            @if($slider->image)
            <div class="mb-6">
                <label class="block text-gray-700 mb-2">الصورة الحالية</label>
                <img src="{{ $slider->image_url }}" 
                     alt="{{ $slider->title }}" 
                     class="h-40 w-full object-cover rounded-lg mb-2"
                     onerror="this.src='data:image/svg+xml,%3Csvg xmlns=\'http://www.w3.org/2000/svg\' width=\'400\' height=\'160\'%3E%3Crect fill=\'%23ddd\' width=\'400\' height=\'160\'/%3E%3Ctext fill=\'%23999\' font-family=\'sans-serif\' font-size=\'14\' x=\'50%25\' y=\'50%25\' text-anchor=\'middle\' dy=\'.3em\'%3Eلا توجد صورة%3C/text%3E%3C/svg%3E';">
            </div>
            @endif

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">العنوان <span class="text-primary">*</span></label>
                <input type="text" name="title" value="{{ old('title', $slider->title) }}" class="w-full px-4 py-2 border rounded-lg" required>
                @error('title')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">الوصف</label>
                <textarea name="description" rows="3" class="w-full px-4 py-2 border rounded-lg">{{ old('description', $slider->description) }}</textarea>
                @error('description')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">تغيير الصورة (اختياري)</label>
                <input type="file" name="image" accept="image/*" class="w-full px-4 py-2 border rounded-lg">
                @error('image')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">الرابط (اختياري)</label>
                <input type="url" name="link" value="{{ old('link', $slider->link) }}" placeholder="https://..." class="w-full px-4 py-2 border rounded-lg">
                @error('link')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div>
                    <label class="block text-gray-700 mb-2">الترتيب</label>
                    <input type="number" name="order" value="{{ old('order', $slider->order) }}" min="0" class="w-full px-4 py-2 border rounded-lg">
                    @error('order')
                    <p class="text-primary text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="flex items-center">
                    <label class="flex items-center cursor-pointer">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $slider->is_active) ? 'checked' : '' }} class="mr-2">
                        <span class="text-gray-700">نشط</span>
                    </label>
                </div>
            </div>

            <div class="flex gap-4">
                <button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg hover:opacity-90 transition">
                    حفظ التغييرات
                </button>
                <a href="{{ route('admin.sliders.index') }}" class="bg-gray-200 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-300 transition">
                    إلغاء
                </a>
            </div>
        </form>
    </div>
</div>
@endsection
