@extends('layouts.app')

@section('title', 'تعديل القياس')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-6">
        <a href="{{ route('admin.sizes.index') }}" class="text-primary hover:opacity-80">← رجوع</a>
    </div>

    <h1 class="text-3xl font-bold text-gray-900 mb-6">تعديل القياس</h1>

    <div class="bg-white rounded-lg shadow p-6">
        <form action="{{ route('admin.sizes.update', $size->id) }}" method="POST">
            @csrf
            @method('PUT')

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">الاسم <span class="text-primary">*</span></label>
                <input type="text" name="name" value="{{ old('name', $size->name) }}" class="w-full px-4 py-2 border rounded-lg" required>
                @error('name')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">الوصف</label>
                <textarea name="description" rows="3" class="w-full px-4 py-2 border rounded-lg">{{ old('description', $size->description) }}</textarea>
                @error('description')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="grid grid-cols-1 md:grid-cols-2 gap-6 mb-6">
                <div>
                    <label class="block text-gray-700 mb-2">الترتيب</label>
                    <input type="number" name="order" min="0" value="{{ old('order', $size->order) }}" class="w-full px-4 py-2 border rounded-lg">
                    @error('order')
                    <p class="text-primary text-sm mt-1">{{ $message }}</p>
                    @enderror
                </div>

                <div class="flex items-center">
                    <label class="flex items-center cursor-pointer">
                        <input type="checkbox" name="is_active" value="1" {{ old('is_active', $size->is_active) ? 'checked' : '' }} class="mr-2">
                        <span class="text-gray-700">نشط</span>
                    </label>
                </div>
            </div>

            <div class="flex gap-4">
                <button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg hover:opacity-90 transition">
                    حفظ التغييرات
                </button>
                <a href="{{ route('admin.sizes.index') }}" class="bg-gray-200 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-300 transition">
                    إلغاء
                </a>
            </div>
        </form>
    </div>
</div>
@endsection

