@extends('layouts.app')

@section('title', 'إعدادات المدير')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-6">
        <h1 class="text-3xl font-bold text-gray-900">لوحة تحكم المدير</h1>
        <p class="mt-2 text-sm text-gray-600">إدارة المتجر - التصنيفات، المنتجات، الطلبات</p>
    </div>

    @if(session('success'))
        <div class="bg-success/20 border border-success text-success px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    <!-- إحصائيات سريعة -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <!-- المنتجات -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600">إجمالي المنتجات</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_products'] }}</p>
                    <p class="text-xs text-gray-500 mt-1">{{ $stats['active_products'] }} نشط</p>
                </div>
                <div class="bg-blue-100 p-3 rounded-full">
                    <svg class="w-8 h-8 text-blue-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20 7l-8-4-8 4m16 0l-8 4m8-4v10l-8 4m0-10L4 7m8 4v10M4 7v10l8 4"></path>
                    </svg>
                </div>
            </div>
            <a href="{{ route('admin.products.index') }}" class="mt-4 inline-block text-sm text-primary hover:underline">إدارة المنتجات →</a>
        </div>

        <!-- التصنيفات -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600">إجمالي التصنيفات</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_categories'] }}</p>
                    <p class="text-xs text-gray-500 mt-1">{{ $stats['active_categories'] }} نشط</p>
                </div>
                <div class="bg-green-100 p-3 rounded-full">
                    <svg class="w-8 h-8 text-green-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"></path>
                    </svg>
                </div>
            </div>
            <a href="{{ route('admin.categories.index') }}" class="mt-4 inline-block text-sm text-primary hover:underline">إدارة التصنيفات →</a>
        </div>

        <!-- الطلبات -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600">إجمالي الطلبات</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_orders'] }}</p>
                    <p class="text-xs text-gray-500 mt-1">{{ $stats['pending_orders'] }} قيد الانتظار</p>
                </div>
                <div class="bg-yellow-100 p-3 rounded-full">
                    <svg class="w-8 h-8 text-yellow-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                    </svg>
                </div>
            </div>
            <a href="{{ route('admin.orders.index') }}" class="mt-4 inline-block text-sm text-primary hover:underline">إدارة الطلبات →</a>
        </div>

        <!-- الإيرادات -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600">إجمالي الإيرادات</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">{{ number_format($stats['total_revenue'], 2) }} ر.ع</p>
                    <p class="text-xs text-gray-500 mt-1">{{ number_format($stats['today_revenue'], 2) }} ر.ع اليوم</p>
                </div>
                <div class="bg-purple-100 p-3 rounded-full">
                    <svg class="w-8 h-8 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                    </svg>
                </div>
            </div>
        </div>
    </div>

    <!-- إحصائيات إضافية: القياسات والسلايدر -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
        <!-- القياسات -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600">إجمالي القياسات</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_sizes'] }}</p>
                    <p class="text-xs text-gray-500 mt-1">{{ $stats['active_sizes'] }} نشط</p>
                </div>
                <div class="bg-indigo-100 p-3 rounded-full">
                    <svg class="w-8 h-8 text-indigo-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 5a1 1 0 011-1h4a1 1 0 011 1v7a1 1 0 01-1 1H5a1 1 0 01-1-1V5zM14 5a1 1 0 011-1h4a1 1 0 011 1v7a1 1 0 01-1 1h-4a1 1 0 01-1-1V5zM4 16a1 1 0 011-1h4a1 1 0 011 1v3a1 1 0 01-1 1H5a1 1 0 01-1-1v-3zM14 16a1 1 0 011-1h4a1 1 0 011 1v3a1 1 0 01-1 1h-4a1 1 0 01-1-1v-3z"></path>
                    </svg>
                </div>
            </div>
            <a href="{{ route('admin.sizes.index') }}" class="mt-4 inline-block text-sm text-primary hover:underline">إدارة القياسات →</a>
        </div>

        <!-- السلايدر -->
        <div class="bg-white rounded-lg shadow p-6">
            <div class="flex items-center justify-between">
                <div>
                    <p class="text-sm text-gray-600">إجمالي السلايدر</p>
                    <p class="text-2xl font-bold text-gray-900 mt-1">{{ $stats['total_sliders'] }}</p>
                    <p class="text-xs text-gray-500 mt-1">{{ $stats['active_sliders'] }} نشط</p>
                </div>
                <div class="bg-pink-100 p-3 rounded-full">
                    <svg class="w-8 h-8 text-pink-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                    </svg>
                </div>
            </div>
            <a href="{{ route('admin.sliders.list') }}" class="mt-4 inline-block text-sm text-primary hover:underline">إدارة السلايدر →</a>
        </div>
    </div>

    <!-- أزرار الإدارة السريعة -->
    <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-4 mb-8">
        <a href="{{ route('admin.categories.create') }}" class="bg-primary text-white p-4 rounded-lg hover:opacity-90 transition text-center">
            <svg class="w-8 h-8 mx-auto mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
            </svg>
            <p class="font-semibold">إضافة تصنيف جديد</p>
        </a>

        <a href="{{ route('admin.products.create') }}" class="bg-success text-white p-4 rounded-lg hover:opacity-90 transition text-center">
            <svg class="w-8 h-8 mx-auto mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4v16m8-8H4"></path>
            </svg>
            <p class="font-semibold">إضافة منتج جديد</p>
        </a>

        <a href="{{ route('admin.sizes.index') }}" class="bg-secondary text-white p-4 rounded-lg hover:opacity-90 transition text-center">
            <svg class="w-8 h-8 mx-auto mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 5a1 1 0 011-1h4a1 1 0 011 1v7a1 1 0 01-1 1H5a1 1 0 01-1-1V5zM14 5a1 1 0 011-1h4a1 1 0 011 1v7a1 1 0 01-1 1h-4a1 1 0 01-1-1V5zM4 16a1 1 0 011-1h4a1 1 0 011 1v3a1 1 0 01-1 1H5a1 1 0 01-1-1v-3zM14 16a1 1 0 011-1h4a1 1 0 011 1v3a1 1 0 01-1 1h-4a1 1 0 01-1-1v-3z"></path>
            </svg>
            <p class="font-semibold">إدارة القياسات</p>
        </a>

        <a href="{{ route('admin.orders.index') }}" class="bg-yellow-500 text-white p-4 rounded-lg hover:opacity-90 transition text-center">
            <svg class="w-8 h-8 mx-auto mb-2" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
            </svg>
            <p class="font-semibold">عرض جميع الطلبات</p>
        </a>
    </div>

    <div class="grid grid-cols-1 lg:grid-cols-2 gap-6">
        <!-- آخر الطلبات -->
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <div class="px-6 py-4 bg-gray-50 border-b flex justify-between items-center">
                <h2 class="text-xl font-semibold text-gray-900">آخر الطلبات</h2>
                <a href="{{ route('admin.orders.index') }}" class="text-sm text-primary hover:underline">عرض الكل →</a>
            </div>
            <div class="divide-y">
                @forelse($recent_orders as $order)
                <div class="px-6 py-4 hover:bg-gray-50">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="font-medium text-gray-900">#{{ $order->order_number }}</p>
                            <p class="text-sm text-gray-500">{{ $order->user->name ?? 'ضيف' }}</p>
                            <p class="text-xs text-gray-400">{{ $order->created_at->diffForHumans() }}</p>
                        </div>
                        <div class="text-left">
                            <p class="font-semibold text-gray-900">{{ number_format($order->total_amount, 2) }} ر.ع</p>
                            <span class="px-2 py-1 text-xs font-semibold rounded-full 
                                @if($order->status === 'pending') bg-yellow-100 text-yellow-800
                                @elseif($order->status === 'processing') bg-blue-100 text-blue-800
                                @elseif($order->status === 'shipped') bg-purple-100 text-purple-800
                                @elseif($order->status === 'delivered') bg-green-100 text-green-800
                                @else bg-red-100 text-red-800
                                @endif">
                                @if($order->status === 'pending') قيد الانتظار
                                @elseif($order->status === 'processing') قيد المعالجة
                                @elseif($order->status === 'shipped') تم الشحن
                                @elseif($order->status === 'delivered') تم التسليم
                                @else ملغي
                                @endif
                            </span>
                        </div>
                    </div>
                </div>
                @empty
                <div class="px-6 py-8 text-center text-gray-500">
                    لا توجد طلبات
                </div>
                @endforelse
            </div>
        </div>

        <!-- منتجات قليلة المخزون -->
        <div class="bg-white rounded-lg shadow overflow-hidden">
            <div class="px-6 py-4 bg-gray-50 border-b flex justify-between items-center">
                <h2 class="text-xl font-semibold text-gray-900">منتجات قليلة المخزون</h2>
                <a href="{{ route('admin.products.index') }}" class="text-sm text-primary hover:underline">عرض الكل →</a>
            </div>
            <div class="divide-y">
                @forelse($low_stock_products as $product)
                <div class="px-6 py-4 hover:bg-gray-50">
                    <div class="flex justify-between items-start">
                        <div>
                            <p class="font-medium text-gray-900">{{ $product->name }}</p>
                            <p class="text-sm text-gray-500">{{ $product->category->name ?? 'بدون تصنيف' }}</p>
                        </div>
                        <div class="text-left">
                            <p class="font-semibold text-red-600">{{ $product->stock }} متبقي</p>
                            <a href="{{ route('admin.products.edit', $product->id) }}" class="text-xs text-primary hover:underline">تحديث المخزون →</a>
                        </div>
                    </div>
                </div>
                @empty
                <div class="px-6 py-8 text-center text-gray-500">
                    جميع المنتجات لديها مخزون كافي
                </div>
                @endforelse
            </div>
        </div>
    </div>

    <!-- إحصائيات الطلبات -->
    <div class="mt-6 bg-white rounded-lg shadow overflow-hidden">
        <div class="px-6 py-4 bg-gray-50 border-b">
            <h2 class="text-xl font-semibold text-gray-900">إحصائيات الطلبات</h2>
        </div>
        <div class="px-6 py-4">
            <div class="grid grid-cols-2 md:grid-cols-5 gap-4">
                <div class="text-center p-4 bg-yellow-50 rounded-lg">
                    <p class="text-2xl font-bold text-yellow-600">{{ $stats['pending_orders'] }}</p>
                    <p class="text-sm text-gray-600 mt-1">قيد الانتظار</p>
                </div>
                <div class="text-center p-4 bg-blue-50 rounded-lg">
                    <p class="text-2xl font-bold text-blue-600">{{ $stats['processing_orders'] }}</p>
                    <p class="text-sm text-gray-600 mt-1">قيد المعالجة</p>
                </div>
                <div class="text-center p-4 bg-purple-50 rounded-lg">
                    <p class="text-2xl font-bold text-purple-600">{{ $stats['shipped_orders'] }}</p>
                    <p class="text-sm text-gray-600 mt-1">تم الشحن</p>
                </div>
                <div class="text-center p-4 bg-green-50 rounded-lg">
                    <p class="text-2xl font-bold text-green-600">{{ $stats['delivered_orders'] }}</p>
                    <p class="text-sm text-gray-600 mt-1">تم التسليم</p>
                </div>
                <div class="text-center p-4 bg-red-50 rounded-lg">
                    <p class="text-2xl font-bold text-red-600">{{ $stats['cancelled_orders'] }}</p>
                    <p class="text-sm text-gray-600 mt-1">ملغي</p>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
