@extends('layouts.app')

@section('title', 'إدارة المنتجات')

@section('content')
<div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="flex justify-between items-center mb-6">
        <h1 class="text-3xl font-bold text-gray-900">إدارة المنتجات</h1>
        <a href="{{ route('admin.products.create') }}" class="bg-primary text-white px-6 py-2 rounded-lg hover:opacity-90 transition">
            + إضافة منتج جديد
        </a>
    </div>

    @if(session('success'))
        <div class="bg-success/20 border border-success text-success px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow overflow-hidden">
        <table class="min-w-full divide-y divide-gray-200">
            <thead class="bg-gray-50">
                <tr>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">الصورة</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">الاسم</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">التصنيف</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">السعر</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">المخزون</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">القياسات / التفصيل</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">الحالة</th>
                    <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase tracking-wider">الإجراءات</th>
                </tr>
            </thead>
            <tbody class="bg-white divide-y divide-gray-200">
                @forelse($products as $product)
                <tr>
                    <td class="px-6 py-4 whitespace-nowrap">
                        @if($product->image)
                            <img src="{{ $product->image_url }}" alt="{{ $product->name }}" class="h-16 w-16 object-cover rounded">
                        @else
                            <div class="h-16 w-16 bg-gray-200 rounded flex items-center justify-center">
                                <svg class="w-8 h-8 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"></path>
                                </svg>
                            </div>
                        @endif
                    </td>
                    <td class="px-6 py-4">
                        <div class="text-sm font-medium text-gray-900">{{ $product->name }}</div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        {{ $product->category->name ?? 'بدون تصنيف' }}
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                        {{ number_format($product->price, 2) }} ر.ع
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                        @php
                            $actualStock = $product->sizes->count() > 0 
                                ? $product->sizes->sum(function($size) { return $size->pivot->stock ?? 0; })
                                : $product->stock;
                        @endphp
                        <span class="{{ $actualStock < 10 ? 'text-red-600 font-semibold' : '' }}">
                            {{ $actualStock }}
                        </span>
                        @if($product->sizes->count() > 0 && $product->stock != $actualStock)
                            <span class="text-xs text-gray-400 block">(المخزون الأساسي: {{ $product->stock }})</span>
                        @endif
                    </td>
                    <td class="px-6 py-4">
                        <div class="space-y-2">
                            @if($product->is_custom)
                                <div class="inline-flex items-center px-2 py-1 rounded-full bg-purple-100 text-purple-800 text-xs font-semibold">
                                    <svg class="w-3 h-3 ml-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                    تفصيل
                                </div>
                            @endif
                            @if($product->sizes->count() > 0)
                                @php
                                    $totalSizesStock = $product->sizes->sum(function($size) {
                                        return $size->pivot->stock ?? 0;
                                    });
                                @endphp
                                <div class="text-xs text-gray-700">
                                    <div class="font-semibold mb-1 flex items-center justify-between">
                                        <span>القياسات ({{ $product->sizes->count() }}):</span>
                                        <span class="text-primary font-bold bg-primary/10 px-2 py-0.5 rounded">
                                            المجموع: {{ $totalSizesStock }}
                                        </span>
                                    </div>
                                    <div class="space-y-1 max-h-24 overflow-y-auto">
                                        @foreach($product->sizes as $size)
                                            @php
                                                $sizeStock = $size->pivot->stock ?? 0;
                                                $sizePrice = $size->pivot->price ?? null;
                                            @endphp
                                            <div class="flex items-center justify-between bg-gray-50 px-2 py-1 rounded text-xs">
                                                <span class="font-medium">{{ $size->name }}</span>
                                                <span class="text-gray-600 {{ $sizeStock < 5 ? 'text-red-600 font-semibold' : '' }}">
                                                    مخزون: {{ $sizeStock }}
                                                </span>
                                                @if($sizePrice)
                                                    <span class="text-primary font-semibold">
                                                        {{ number_format($sizePrice, 2) }} ر.ع
                                                    </span>
                                                @endif
                                            </div>
                                        @endforeach
                                    </div>
                                </div>
                            @else
                                <span class="text-xs text-gray-400">لا توجد قياسات</span>
                            @endif
                        </div>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <span class="px-2 inline-flex text-xs leading-5 font-semibold rounded-full {{ $product->is_active ? 'bg-success text-white' : 'bg-gray-200 text-gray-800' }}">
                            {{ $product->is_active ? 'نشط' : 'غير نشط' }}
                        </span>
                    </td>
                    <td class="px-6 py-4 whitespace-nowrap">
                        <div class="flex items-center gap-2">
                            <a href="{{ route('admin.products.edit', $product->id) }}" class="group inline-flex items-center px-4 py-2 bg-gradient-to-r from-blue-500 to-blue-600 text-white rounded-lg hover:from-blue-600 hover:to-blue-700 transition-all duration-200 shadow-md hover:shadow-lg text-sm font-medium">
                                <svg class="w-4 h-4 ml-2 group-hover:rotate-12 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                                </svg>
                                تعديل
                            </a>
                            <form action="{{ route('admin.products.destroy', $product->id) }}" method="POST" class="inline delete-form" data-confirm-message="هل أنت متأكد من حذف المنتج '{{ $product->name }}'؟ لا يمكن التراجع عن هذا الإجراء.">
                                @csrf
                                @method('DELETE')
                                <button type="submit" class="group inline-flex items-center px-4 py-2 bg-gradient-to-r from-red-500 to-red-600 text-white rounded-lg hover:from-red-600 hover:to-red-700 transition-all duration-200 shadow-md hover:shadow-lg text-sm font-medium">
                                    <svg class="w-4 h-4 ml-2 group-hover:scale-110 transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                                    </svg>
                                    حذف
                                </button>
                            </form>
                        </div>
                    </td>
                </tr>
                @empty
                <tr>
                    <td colspan="8" class="px-6 py-4 text-center text-gray-500">
                        لا توجد منتجات
                    </td>
                </tr>
                @endforelse
            </tbody>
        </table>
    </div>
</div>
@endsection

