@extends('layouts.app')

@section('title', 'تفاصيل الطلب')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-6">
        <a href="{{ route('admin.orders.index') }}" class="text-primary hover:opacity-80">← رجوع</a>
    </div>

    <h1 class="text-3xl font-bold text-gray-900 mb-6">تفاصيل الطلب</h1>

    @if(session('success'))
        <div class="bg-success/20 border border-success text-success px-4 py-3 rounded mb-4">
            {{ session('success') }}
        </div>
    @endif

    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <div class="grid md:grid-cols-2 gap-6 mb-6">
            <div>
                <h3 class="font-semibold mb-2">رقم الطلب</h3>
                <p class="text-gray-600">#{{ $order->order_number }}</p>
            </div>
            <div>
                <h3 class="font-semibold mb-2">حالة الطلب</h3>
                <span class="px-3 py-1 rounded-full text-sm font-medium
                    @if($order->status === 'pending') bg-yellow-100 text-yellow-800
                    @elseif($order->status === 'processing') bg-blue-100 text-blue-800
                    @elseif($order->status === 'shipped') bg-purple-100 text-purple-800
                    @elseif($order->status === 'delivered') bg-green-100 text-green-800
                    @else bg-red-100 text-red-800
                    @endif">
                    @if($order->status === 'pending') قيد الانتظار
                    @elseif($order->status === 'processing') قيد المعالجة
                    @elseif($order->status === 'shipped') تم الشحن
                    @elseif($order->status === 'delivered') تم التسليم
                    @else ملغي
                    @endif
                </span>
            </div>
            <div>
                <h3 class="font-semibold mb-2">تاريخ الطلب</h3>
                <p class="text-gray-600">{{ $order->created_at->format('Y-m-d H:i') }}</p>
            </div>
            <div>
                <h3 class="font-semibold mb-2">المبلغ الإجمالي</h3>
                <p class="text-gray-600 text-xl font-bold">{{ number_format($order->total_amount, 2) }} ر.ع</p>
                @if($order->points_earned > 0)
                <p class="text-sm text-success mt-1">النقاط المكتسبة: +{{ $order->points_earned }} نقاط</p>
                @endif
            </div>
        </div>

        <!-- تحديث حالة الطلب -->
        <div class="border-t pt-6">
            <h3 class="font-semibold mb-4">تحديث حالة الطلب</h3>
            <form action="{{ route('admin.orders.updateStatus', $order->id) }}" method="POST" class="flex gap-4">
                @csrf
                <select name="status" class="px-4 py-2 border rounded-lg" required>
                    <option value="pending" {{ $order->status === 'pending' ? 'selected' : '' }}>قيد الانتظار</option>
                    <option value="processing" {{ $order->status === 'processing' ? 'selected' : '' }}>قيد المعالجة</option>
                    <option value="shipped" {{ $order->status === 'shipped' ? 'selected' : '' }}>تم الشحن</option>
                    <option value="delivered" {{ $order->status === 'delivered' ? 'selected' : '' }}>تم التسليم</option>
                    <option value="cancelled" {{ $order->status === 'cancelled' ? 'selected' : '' }}>ملغي</option>
                </select>
                <button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg hover:opacity-90 transition">
                    تحديث الحالة
                </button>
            </form>
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6 mb-6">
        <h2 class="text-xl font-semibold mb-4">عنوان الشحن</h2>
        <div class="space-y-2">
            <p><strong>اسم المستلم:</strong> {{ $order->shipping_name }}</p>
            <p><strong>رقم الهاتف:</strong> {{ $order->shipping_phone }}</p>
            <p><strong>المدينة:</strong> {{ $order->shipping_city }}</p>
            <p><strong>العنوان:</strong> {{ $order->shipping_address }}</p>
            @if($order->notes)
            <p><strong>ملاحظات:</strong> {{ $order->notes }}</p>
            @endif
        </div>
    </div>

    <div class="bg-white rounded-lg shadow p-6">
        <h2 class="text-xl font-semibold mb-4">عناصر الطلب</h2>
        <div class="overflow-x-auto">
            <table class="min-w-full divide-y divide-gray-200">
                <thead class="bg-gray-50">
                    <tr>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">المنتج</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">الكمية</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">السعر</th>
                        <th class="px-6 py-3 text-right text-xs font-medium text-gray-500 uppercase">المجموع</th>
                    </tr>
                </thead>
                <tbody class="bg-white divide-y divide-gray-200">
                    @foreach($order->items as $item)
                    @php
                        $productName = $item->product->name ?? $item->product_name ?? 'منتج محذوف';
                        // استخراج اسم القياس من product_name إذا كان موجوداً (للطلبات القديمة)
                        $sizeNameFromProductName = null;
                        if (str_contains($item->product_name ?? '', ' - ')) {
                            $parts = explode(' - ', $item->product_name);
                            if (count($parts) > 1) {
                                $productName = $parts[0];
                                $sizeNameFromProductName = $parts[1];
                            }
                        }
                    @endphp
                    <tr>
                        <td class="px-6 py-4">
                            <div class="text-sm font-medium text-gray-900">{{ $productName }}</div>
                            
                            @if($item->size)
                            <div class="mt-1 text-xs text-gray-600">
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-gray-100 text-gray-700">
                                    <span class="ml-1 rtl:mr-1 rtl:ml-0 font-semibold">القياس:</span>
                                    <span>{{ $item->size->name }}</span>
                                </span>
                            </div>
                            @elseif($sizeNameFromProductName)
                            <div class="mt-1 text-xs text-gray-600">
                                <span class="inline-flex items-center px-2 py-0.5 rounded-full bg-gray-100 text-gray-700">
                                    <span class="ml-1 rtl:mr-1 rtl:ml-0 font-semibold">القياس:</span>
                                    <span>{{ $sizeNameFromProductName }}</span>
                                </span>
                            </div>
                            @endif
                            
                            @if($item->custom_measurements && is_array($item->custom_measurements) && !empty($item->custom_measurements))
                            <div class="mt-2 p-2 bg-purple-50 border border-purple-200 rounded text-xs">
                                <div class="flex items-center gap-1 mb-1">
                                    <svg class="w-3 h-3 text-purple-600" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12h6m-6 4h6m2 5H7a2 2 0 01-2-2V5a2 2 0 012-2h5.586a1 1 0 01.707.293l5.414 5.414a1 1 0 01.293.707V19a2 2 0 01-2 2z"></path>
                                    </svg>
                                    <span class="font-semibold text-purple-800">قياسات التفصيل:</span>
                                </div>
                                <div class="text-purple-700 space-y-0.5">
                                    @if(isset($item->custom_measurements['measurement_1']) && $item->custom_measurements['measurement_1'])
                                    <div>القياس الأول: <span class="font-semibold">{{ $item->custom_measurements['measurement_1'] }} سم</span></div>
                                    @endif
                                    @if(isset($item->custom_measurements['measurement_2']) && $item->custom_measurements['measurement_2'])
                                    <div>القياس الثاني: <span class="font-semibold">{{ $item->custom_measurements['measurement_2'] }} سم</span></div>
                                    @endif
                                    @if(isset($item->custom_measurements['measurement_3']) && $item->custom_measurements['measurement_3'])
                                    <div>القياس الثالث: <span class="font-semibold">{{ $item->custom_measurements['measurement_3'] }} سم</span></div>
                                    @endif
                                </div>
                            </div>
                            @endif
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            {{ $item->quantity }}
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                            {{ number_format($item->price, 2) }} ر.ع
                        </td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-medium text-gray-900">
                            {{ number_format($item->quantity * $item->price, 2) }} ر.ع
                        </td>
                    </tr>
                    @endforeach
                </tbody>
                <tfoot class="bg-gray-50">
                    <tr>
                        <td colspan="3" class="px-6 py-4 text-right text-sm font-medium text-gray-900">المجموع الإجمالي</td>
                        <td class="px-6 py-4 whitespace-nowrap text-sm font-bold text-gray-900">
                            {{ number_format($order->total_amount, 2) }} ر.ع
                        </td>
                    </tr>
                </tfoot>
            </table>
        </div>
    </div>
</div>
@endsection

