@extends('layouts.app')

@section('title', 'تعديل التصنيف')

@section('content')
<div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
    <div class="mb-6">
        <a href="{{ route('admin.categories.index') }}" class="text-primary hover:opacity-80">← رجوع</a>
    </div>

    <h1 class="text-3xl font-bold text-gray-900 mb-6">تعديل التصنيف</h1>

    <div class="bg-white rounded-lg shadow p-6">
        <form action="{{ route('admin.categories.update', $category->id) }}" method="POST" enctype="multipart/form-data">
            @csrf
            @method('PUT')

            @if($category->image)
            <div class="mb-6">
                <label class="block text-gray-700 mb-2">الصورة الحالية</label>
                <img src="{{ $category->image_url }}" alt="{{ $category->name }}" class="h-32 w-32 object-cover rounded-lg">
            </div>
            @endif

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">الاسم <span class="text-primary">*</span></label>
                <input type="text" name="name" value="{{ old('name', $category->name) }}" class="w-full px-4 py-2 border rounded-lg" required>
                @error('name')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">الوصف</label>
                <textarea name="description" rows="3" class="w-full px-4 py-2 border rounded-lg">{{ old('description', $category->description) }}</textarea>
                @error('description')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="block text-gray-700 mb-2">تغيير الصورة</label>
                <input type="file" name="image" accept="image/*" class="w-full px-4 py-2 border rounded-lg">
                @error('image')
                <p class="text-primary text-sm mt-1">{{ $message }}</p>
                @enderror
            </div>

            <div class="mb-6">
                <label class="flex items-center cursor-pointer">
                    <input type="checkbox" name="is_active" value="1" {{ old('is_active', $category->is_active) ? 'checked' : '' }} class="mr-2">
                    <span class="text-gray-700">نشط</span>
                </label>
            </div>

            <div class="flex gap-4">
                <button type="submit" class="bg-primary text-white px-6 py-2 rounded-lg hover:opacity-90 transition">
                    حفظ التغييرات
                </button>
                <a href="{{ route('admin.categories.index') }}" class="bg-gray-200 text-gray-700 px-6 py-2 rounded-lg hover:bg-gray-300 transition">
                    إلغاء
                </a>
            </div>
        </form>
    </div>
</div>
@endsection

