<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\DB;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('sliders', function (Blueprint $table) {
            // إعادة تسمية الأعمدة العربية
            if (Schema::hasColumn('sliders', 'title_ar')) {
                DB::statement('ALTER TABLE `sliders` CHANGE `title_ar` `title` VARCHAR(255) NULL');
            }
            if (Schema::hasColumn('sliders', 'description_ar')) {
                DB::statement('ALTER TABLE `sliders` CHANGE `description_ar` `description` TEXT NULL');
            }
            
            // حذف الأعمدة الإنجليزية
            if (Schema::hasColumn('sliders', 'title_en')) {
                $table->dropColumn('title_en');
            }
            if (Schema::hasColumn('sliders', 'description_en')) {
                $table->dropColumn('description_en');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('sliders', function (Blueprint $table) {
            // إعادة الأعمدة الإنجليزية
            $table->string('title_en')->nullable()->after('title');
            $table->text('description_en')->nullable()->after('description');
            
            // إعادة تسمية الأعمدة
            if (Schema::hasColumn('sliders', 'title')) {
                DB::statement('ALTER TABLE `sliders` CHANGE `title` `title_ar` VARCHAR(255) NULL');
            }
            if (Schema::hasColumn('sliders', 'description')) {
                DB::statement('ALTER TABLE `sliders` CHANGE `description` `description_ar` TEXT NULL');
            }
        });
    }
};

