<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('order_items', function (Blueprint $table) {
            if (!Schema::hasColumn('order_items', 'size_id')) {
                $table->foreignId('size_id')->nullable()->after('product_id')->constrained()->onDelete('set null');
            }
            if (!Schema::hasColumn('order_items', 'custom_measurements')) {
                $table->json('custom_measurements')->nullable()->after('subtotal');
            }
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('order_items', function (Blueprint $table) {
            if (Schema::hasColumn('order_items', 'custom_measurements')) {
                $table->dropColumn('custom_measurements');
            }
            if (Schema::hasColumn('order_items', 'size_id')) {
                $table->dropForeign(['size_id']);
                $table->dropColumn('size_id');
            }
        });
    }
};

