<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('carts', 'custom_measurements')) {
            Schema::table('carts', function (Blueprint $table) {
                $table->json('custom_measurements')->nullable()->after('quantity');
            });
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        if (Schema::hasColumn('carts', 'custom_measurements')) {
            Schema::table('carts', function (Blueprint $table) {
                $table->dropColumn('custom_measurements');
            });
        }
    }
};


