<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasColumn('carts', 'size_id')) {
            Schema::table('carts', function (Blueprint $table) {
                $table->foreignId('size_id')->nullable()->after('product_id')->constrained()->onDelete('cascade');
            });
        }
        
        // إزالة unique constraint القديم وإضافة الجديد
        if (Schema::hasColumn('carts', 'size_id')) {
            try {
                Schema::table('carts', function (Blueprint $table) {
                    $table->dropUnique(['user_id', 'product_id']);
                });
            } catch (\Exception $e) {
                // قد لا يكون موجوداً
            }
            
            try {
                Schema::table('carts', function (Blueprint $table) {
                    $table->unique(['user_id', 'product_id', 'size_id']);
                });
            } catch (\Exception $e) {
                // قد يكون موجوداً بالفعل
            }
        }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('carts', function (Blueprint $table) {
            $table->dropUnique(['user_id', 'product_id', 'size_id']);
            $table->unique(['user_id', 'product_id']);
            $table->dropForeign(['size_id']);
            $table->dropColumn('size_id');
        });
    }
};
