<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsTo;
use App\Models\Size;

class Cart extends Model
{
    protected $fillable = [
        'user_id',
        'product_id',
        'size_id',
        'quantity',
        'custom_measurements',
    ];

    protected $casts = [
        'quantity' => 'integer',
        'custom_measurements' => 'array',
    ];

    public function user(): BelongsTo
    {
        return $this->belongsTo(User::class);
    }

    public function product(): BelongsTo
    {
        return $this->belongsTo(Product::class);
    }

    public function size(): BelongsTo
    {
        return $this->belongsTo(Size::class);
    }

    public function getItemPriceAttribute()
    {
        $basePrice = $this->product->price;
        
        // إذا كان التصنيف 8 واختار العميل تفصيل، أضف 5 ريال
        if ($this->product->category_id == 8 && $this->custom_measurements) {
            $basePrice += 5;
        }
        
        return $basePrice;
    }
    
    public function getSubtotalAttribute()
    {
        return $this->quantity * $this->item_price;
    }
}
