<?php

namespace App\Http\Controllers;

use App\Models\Product;
use App\Models\Category;
use Illuminate\Http\Request;

class ProductController extends Controller
{
    public function index(Request $request)
    {
        $query = Product::where('is_active', true)->with('category');
        
        if ($request->has('category_id') && $request->category_id) {
            $query->where('category_id', $request->category_id);
        }
        
        if ($request->has('search') && $request->search) {
            $search = $request->search;
            $query->where(function($q) use ($search) {
                $q->where('name_ar', 'like', "%{$search}%")
                  ->orWhere('name_en', 'like', "%{$search}%")
                  ->orWhere('description_ar', 'like', "%{$search}%")
                  ->orWhere('description_en', 'like', "%{$search}%");
            });
        }
        
        $products = $query->latest()->paginate(12);
        $categories = Category::where('is_active', true)->get();
        
        return view('products.index', compact('products', 'categories'));
    }

    public function show(Request $request, $id)
    {
        $product = Product::where('is_active', true)
            ->with(['category', 'sizes'])
            ->findOrFail($id);
        
        $relatedProducts = Product::where('category_id', $product->category_id)
            ->where('id', '!=', $product->id)
            ->where('is_active', true)
            ->take(4)
            ->get();

        // قراءات خاصة عند القدوم من السلة (لقياس أو قياسات تفصيل)
        $selectedSizeIdFromCart = $request->query('size_id');
        $selectedSizeFromCart = $selectedSizeIdFromCart
            ? $product->sizes->where('id', $selectedSizeIdFromCart)->first()
            : null;

        $customMeasurementsFromCart = null;
        if ($request->filled('cm')) {
            $decoded = json_decode(base64_decode($request->query('cm')), true);
            if (is_array($decoded)) {
                $customMeasurementsFromCart = $decoded;
            }
        }
        
        return view('products.show', compact(
            'product',
            'relatedProducts',
            'selectedSizeIdFromCart',
            'selectedSizeFromCart',
            'customMeasurementsFromCart'
        ));
    }
}
